using System;
using System.Drawing;
using System.Collections;
using System.ComponentModel;
using System.Windows.Forms;
using System.Data;

namespace CellTree
{
	/// <summary>
	/// CtH[łB
	/// </summary>
	public class frmCellTree : System.Windows.Forms.Form
	{
		#region Windows tH[ fUCiŐꂽR[h 
		/// <summary>
		/// Rg[łB
		/// </summary>
		public System.Windows.Forms.TextBox txtInfo;
		public System.Windows.Forms.Label lblInfo;
		public System.Windows.Forms.ToolTip tipInfo;
		public System.Windows.Forms.PictureBox picInfo;
		public AxKnTViewLib.AxKnTView KnTView1;

		/// <summary>
		/// KvȃfUCiϐłB
		/// </summary>
		private System.ComponentModel.IContainer components;

		/// <summary>
		/// fUCi T|[gɕKvȃ\bhłB̃\bh̓e
		/// R[h GfB^ŕύXȂłB
		/// </summary>
		private void InitializeComponent()
		{
			this.components = new System.ComponentModel.Container();
			System.Resources.ResourceManager resources = new System.Resources.ResourceManager(typeof(frmCellTree));
			this.txtInfo = new System.Windows.Forms.TextBox();
			this.lblInfo = new System.Windows.Forms.Label();
			this.tipInfo = new System.Windows.Forms.ToolTip(this.components);
			this.picInfo = new System.Windows.Forms.PictureBox();
			this.KnTView1 = new AxKnTViewLib.AxKnTView();
			((System.ComponentModel.ISupportInitialize)(this.KnTView1)).BeginInit();
			this.SuspendLayout();
			// 
			// txtInfo
			// 
			this.txtInfo.AcceptsReturn = true;
			this.txtInfo.AutoSize = false;
			this.txtInfo.BackColor = System.Drawing.SystemColors.Control;
			this.txtInfo.BorderStyle = System.Windows.Forms.BorderStyle.None;
			this.txtInfo.Cursor = System.Windows.Forms.Cursors.IBeam;
			this.txtInfo.ForeColor = System.Drawing.SystemColors.ControlText;
			this.txtInfo.Location = new System.Drawing.Point(9, 9);
			this.txtInfo.MaxLength = 0;
			this.txtInfo.Multiline = true;
			this.txtInfo.Name = "txtInfo";
			this.txtInfo.ReadOnly = true;
			this.txtInfo.RightToLeft = System.Windows.Forms.RightToLeft.No;
			this.txtInfo.Size = new System.Drawing.Size(546, 54);
			this.txtInfo.TabIndex = 2;
			this.txtInfo.Text = "Z̃c[\̂߂̋@\T|[gĂ܂B̃Tvł́AL̋@\Ă܂B\r\nEqACe̕\^\\r\nEZ̃Cfg̕ύX\r\nE" +
				"ACëړ\r\n";
			// 
			// lblInfo
			// 
			this.lblInfo.BackColor = System.Drawing.SystemColors.Control;
			this.lblInfo.Cursor = System.Windows.Forms.Cursors.Default;
			this.lblInfo.ForeColor = System.Drawing.SystemColors.ControlText;
			this.lblInfo.Location = new System.Drawing.Point(567, 45);
			this.lblInfo.Name = "lblInfo";
			this.lblInfo.RightToLeft = System.Windows.Forms.RightToLeft.No;
			this.lblInfo.Size = new System.Drawing.Size(49, 15);
			this.lblInfo.TabIndex = 3;
			this.lblInfo.Text = "Click !";
			this.lblInfo.TextAlign = System.Drawing.ContentAlignment.TopCenter;
			// 
			// picInfo
			// 
			this.picInfo.BackColor = System.Drawing.SystemColors.Control;
			this.picInfo.Cursor = System.Windows.Forms.Cursors.Default;
			this.picInfo.ForeColor = System.Drawing.SystemColors.WindowText;
			this.picInfo.Image = ((System.Drawing.Bitmap)(resources.GetObject("picInfo.Image")));
			this.picInfo.Location = new System.Drawing.Point(575, 9);
			this.picInfo.Name = "picInfo";
			this.picInfo.RightToLeft = System.Windows.Forms.RightToLeft.No;
			this.picInfo.Size = new System.Drawing.Size(33, 33);
			this.picInfo.TabIndex = 9;
			this.picInfo.TabStop = false;
			this.tipInfo.SetToolTip(this.picInfo, "̃ACRNbNƐ\܂B");
			this.picInfo.Click += new System.EventHandler(this.picInfo_Click);
			// 
			// KnTView1
			// 
			this.KnTView1.Anchor = (((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
				| System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right);
			this.KnTView1.Location = new System.Drawing.Point(0, 63);
			this.KnTView1.Name = "KnTView1";
			this.KnTView1.OcxState = ((System.Windows.Forms.AxHost.State)(resources.GetObject("KnTView1.OcxState")));
			this.KnTView1.Size = new System.Drawing.Size(622, 262);
			this.KnTView1.TabIndex = 0;
			this.KnTView1.AfterCellIndentMouseChange += new AxKnTViewLib._DKnTViewEvents_AfterCellIndentMouseChangeEventHandler(this.KnTView1_AfterCellIndentMouseChange);
			this.KnTView1.MouseDownEvent += new AxKnTViewLib._DKnTViewEvents_MouseDownEventHandler(this.KnTView1_MouseDownEvent);
			this.KnTView1.MouseUpEvent += new AxKnTViewLib._DKnTViewEvents_MouseUpEventHandler(this.KnTView1_MouseUpEvent);
			this.KnTView1.BeforeCellIndentMouseChange += new AxKnTViewLib._DKnTViewEvents_BeforeCellIndentMouseChangeEventHandler(this.KnTView1_BeforeCellIndentMouseChange);
			// 
			// frmCellTree
			// 
			this.AutoScaleBaseSize = new System.Drawing.Size(5, 12);
			this.ClientSize = new System.Drawing.Size(622, 326);
			this.Controls.AddRange(new System.Windows.Forms.Control[] {
																		  this.KnTView1,
																		  this.picInfo,
																		  this.lblInfo,
																		  this.txtInfo});
			this.Icon = ((System.Drawing.Icon)(resources.GetObject("$this.Icon")));
			this.Location = new System.Drawing.Point(4, 23);
			this.Name = "frmCellTree";
			this.StartPosition = System.Windows.Forms.FormStartPosition.CenterScreen;
			this.Text = "^Cr[@\Љ - Z̃c[\";
			this.Load += new System.EventHandler(this.frmCellTree_Load);
			((System.ComponentModel.ISupportInitialize)(this.KnTView1)).EndInit();
			this.ResumeLayout(false);

		}
		#endregion

		// ړACeCfbNX
		private int m_intOldItemIndex;
		private int m_intNewItemIndex;

		// ACȅԒ萔
		private const string cstrNoChildren  = "qȂ";
		private const string cstrOpen = "J";
		private const string cstrClose = "";
	
		// ZCfbNX
		private const int cintMoveItemCellIndex	= 1;
		private const int cintTreeCellIndex		= 2;

		/// <summary>
		/// AvP[ṼC Gg |CgłB
		/// </summary>
		[STAThread]
		static void Main() 
		{
			Application.Run(new frmCellTree());
		}

		/// <summary>
		/// RXgN^łB
		/// </summary>
		public frmCellTree()
		{
			//
			// Windows tH[ fUCi T|[gɕKvłB
			//
			InitializeComponent();

			//
			// TODO: InitializeComponent ĂяǒɁARXgN^ R[hǉĂB
			//
		}

		/// <summary>
		/// gpĂ郊\[XɌ㏈s܂B
		/// </summary>
		protected override void Dispose( bool disposing )
		{
			if( disposing )
			{
				if (components != null) 
				{
					components.Dispose();
				}
			}
			base.Dispose( disposing );
		}

		/// <summary>
		/// tH[LoadCxgłB
		/// </summary>
		/// <param name="sender">
		/// Cxgsenderp[^B
		/// </param>
		/// <param name="e">
		/// Cxgep[^B
		/// </param>
		private void frmCellTree_Load(object sender, System.EventArgs e)
		{
			// C[W̏
			KnTViewLib.ImageList imgList;
			object[] iList = {cstrClose, cstrOpen, cstrNoChildren};
			imgList = KnTView1.ImageLists.Add(null, "ImageList", Application.StartupPath + "\\..\\..\\..\\CellTreeImages.bmp", RGB(255, 0, 255), 16, 16);
			imgList.Images.Keys = iList;

			// J̒ǉ
			KnTView1.ColumnHeaders.Add(null, null);
			KnTView1.ColumnHeaders.Item(cintMoveItemCellIndex).Width = 14;
			KnTView1.CellEdit = KnTViewLib.TivMode.tivManual;
			KnTView1.ColumnHeaders.Item(cintTreeCellIndex).Width = 90;
		
			// Cfg̐ݒ
			KnTView1.ColumnHeaders.Item(cintTreeCellIndex).IndentWidth = 18;
			KnTView1.ColumnHeaders.Item(cintTreeCellIndex).IndentUIWidth = 8;
			KnTView1.ColumnHeaders.Item(cintTreeCellIndex).IndentUIPosition = 18;
		
			// ACe̒ǉ
			AddItem("1", 1, cstrNoChildren);
			AddItem("2", 1, cstrOpen);
			AddItem("2.1", 2, cstrNoChildren);
			
			AddItem("3", 1, cstrOpen);
			AddItem("3.1", 2, cstrNoChildren);
			AddItem("3.2", 2, cstrNoChildren);
			
			AddItem("4", 1, cstrOpen);
			AddItem("4.1", 2, cstrOpen);
			AddItem("4.1.1", 3, cstrNoChildren);
			AddItem("4.1.2", 3, cstrNoChildren);
			
			AddItem("5", 1, cstrOpen);
			AddItem("5.1", 2, cstrOpen);
			AddItem("5.1.1", 3, cstrOpen);
			AddItem("5.1.1.1", 4, cstrNoChildren);
			AddItem("5.1.1.2", 4, cstrNoChildren);
		
			// qACe̔\
			HideChildren(13, true);
			HideChildren(12, true);
			HideChildren(11, true);
			HideChildren(8, true);
			HideChildren(7, true);
			HideChildren(4, true);
			HideChildren(2, true);
		}

		/// <summary>
		/// ^Cr[AfterCellIndentMouseChangeCxgłB
		/// </summary>
		/// <param name="sender">
		/// Cxgsenderp[^B
		/// </param>
		/// <param name="e">
		/// Cxgep[^B
		/// </param>
		private void KnTView1_AfterCellIndentMouseChange(object sender, AxKnTViewLib._DKnTViewEvents_AfterCellIndentMouseChangeEvent e)
		{
			SetIndent(e.cell.ItemIndex, e.newIndentLevel, GetChildrenCount(e.cell.ItemIndex));

			// ZC[W̒
			AdjustCellImage((e.cell.ItemIndex));
		}

		/// <summary>
		/// ^Cr[BeforeCellIndentMouseChangeCxgłB
		/// </summary>
		/// <param name="sender">
		/// Cxgsenderp[^B
		/// </param>
		/// <param name="e">
		/// Cxgep[^B
		/// </param>
		private void KnTView1_BeforeCellIndentMouseChange(object sender, AxKnTViewLib._DKnTViewEvents_BeforeCellIndentMouseChangeEvent e)
		{
			if(e.cell.ItemIndex == 1){
				e.cancel.Value = true;
				return;
			}
			e.maxIndentLevel = KnTView1.Items.Item(e.cell.ItemIndex - 1).Cells.Item(cintTreeCellIndex).IndentLevel + 1;
		}

		/// <summary>
		/// ^Cr[MouseDownEventCxgłB
		/// </summary>
		/// <param name="sender">
		/// Cxgsenderp[^B
		/// </param>
		/// <param name="e">
		/// Cxgep[^B
		/// </param>
		private void KnTView1_MouseDownEvent(object sender, AxKnTViewLib._DKnTViewEvents_MouseDownEvent e)
		{
			float cntrX;
			float cntrY;
			KnTViewLib.HitTestResult result;

			cntrX = e.x;
			cntrY = e.y;

			result = KnTView1.HitTest(cntrX, cntrY);

			switch(result.ObjectType){
			case KnTViewLib.TivObjectType.tivCell:
				switch(int.Parse(result.ColumnIndex.ToString())){
				// c[Z̃C[W̃}EX_EŎqACe̕\^\
				case cintTreeCellIndex:
					if(result.OnImage){
						int itemIndex = int.Parse(result.ItemIndex.ToString());
						if(GetChildrenCount(itemIndex) > 0){
							if(IsOpen(itemIndex))
								HideChildren(itemIndex, true);
							else
								HideChildren(itemIndex, false);
						}
					}
					break;

				// ACeړ
				case cintMoveItemCellIndex:
					m_intOldItemIndex = int.Parse(result.ItemIndex.ToString());
					m_intNewItemIndex = KnTView1.StartMoveItem(cntrX, cntrY, false);
					break;
				}
				break;
			}
		}

		/// <summary>
		/// ^Cr[MouseUpEventCxgłB
		/// </summary>
		/// <param name="sender">
		/// Cxgsenderp[^B
		/// </param>
		/// <param name="e">
		/// Cxgep[^B
		/// </param>
		private void KnTView1_MouseUpEvent(object sender, AxKnTViewLib._DKnTViewEvents_MouseUpEvent e)
		{
			if(m_intOldItemIndex != 0 && m_intNewItemIndex != 0)
				MoveItems(m_intOldItemIndex, m_intNewItemIndex);

			m_intOldItemIndex = 0;
			m_intNewItemIndex = 0;
		}

		/// <summary>
		/// ACRClickCxgłB
		/// </summary>
		/// <param name="sender">
		/// Cxgsenderp[^B
		/// </param>
		/// <param name="e">
		/// Cxgep[^B
		/// </param>
		private void picInfo_Click(object sender, System.EventArgs e)
		{
			string strPrompt;
			strPrompt = "E2ڂ̃Z̃C[W(vX^}CiX)NbNƁAqACe\n@\^\邱Ƃł܂B\n\n";
			strPrompt += "E2ڂ̃Z̃C[Wƕ̊ԂhbO邱ƂŁAACẽC\n@fgύX邱Ƃł܂B\n\n";
			strPrompt += "E1ڂ̃ZhbO邱ƂŁAACëʒuړ邱Ƃł\n@܂B\n";
			MessageBox.Show(strPrompt, "̃Tv̎g", MessageBoxButtons.OK, MessageBoxIcon.Information);
		}

		/// <summary>
		/// Z̃C[W𒲐܂B
		/// </summary>
		/// <param name="intItemIndex">
		/// ΏۃACẽCfbNXB
		/// </param>
		private void AdjustCellImage(int intItemIndex)
		{
			KnTViewLib.Cell cellTarget;
			string strTag;

			// eACeꍇ
			if(intItemIndex > 1){
				cellTarget = KnTView1.Items.Item(intItemIndex - 1).Cells.Item(cintTreeCellIndex);

				if(HasParent(intItemIndex))
					SetImageToCell(cstrOpen, cellTarget);
				else
					SetImageToCell(cstrNoChildren, cellTarget);
			}

			// qACeꍇ
			cellTarget = KnTView1.Items.Item(intItemIndex).Cells.Item(cintTreeCellIndex);

			if(GetChildrenCount(intItemIndex) > 0)
				SetImageToCell(KnTView1.Items.Item(intItemIndex).Cells.Item(cintTreeCellIndex).Tag, cellTarget);
			else
				SetImageToCell(cstrNoChildren, cellTarget);
		
			if(GetChildrenCount(intItemIndex) > 0){
				strTag = KnTView1.Items.Item(intItemIndex).Cells.Item(cintTreeCellIndex).Tag;
				if(strTag != cstrNoChildren)
					SetImageToCell(strTag, cellTarget);
				else
					SetImageToCell(cstrOpen, cellTarget);
			}
			else
				SetImageToCell(cstrNoChildren, cellTarget);
		}

		/// <summary>
		/// C[WZɐݒ
		/// </summary>
		/// <param name="strStatus">
		/// ACȅԁB
		/// </param>
		/// <param name="cellTarget">
		/// Ώۂ̃ZB
		/// </param>
		private void SetImageToCell(string strStatus, KnTViewLib.Cell cellTarget)
		{
			switch(strStatus){
			case cstrNoChildren:	// qȂ
				cellTarget.Image("ImageList", cstrNoChildren);
				cellTarget.Tag = cstrNoChildren;
				break;
			case cstrOpen:			// J
				cellTarget.Image("ImageList", cstrOpen);
				cellTarget.Tag = cstrOpen;
				break;
			case cstrClose:			// 
				cellTarget.Image("ImageList", cstrClose);
				cellTarget.Tag = cstrClose;
				break;
			}
		}

		/// <summary>
		/// ACeǉ܂B
		/// </summary>
		/// <param name="strText">
		/// Zɕ\镶B
		/// </param>
		/// <param name="intIndentLevel">
		/// CfgxB
		/// </param>
		/// <param name="strStatus">
		/// ACȅԁB
		/// </param>
		/// <returns>
		/// ǉACeB
		/// </returns>
		private object AddItem(string strText, int intIndentLevel, string strStatus)
		{
			KnTViewLib.Item itemNew;
			KnTViewLib.Piece pieceNew;

			itemNew = KnTView1.Items.Add(null, null);

			itemNew.Cells.Item(cintTreeCellIndex).Value = strText;
			itemNew.Cells.Item(cintTreeCellIndex).IndentLevel = intIndentLevel;
			itemNew.Cells.Item(cintTreeCellIndex).ImagePosition = KnTViewLib.TivImagePosition.tivImagePositionLeft;

			itemNew.Cells.Item(cintMoveItemCellIndex).Fill.Pattern = KnTViewLib.TivFillPattern.tivPattern3D;
			itemNew.Cells.Item(cintMoveItemCellIndex).Fill.BackColor = System.Convert.ToUInt32(0xAAAAAA);

			SetImageToCell(strStatus, itemNew.Cells.Item(cintTreeCellIndex));

			pieceNew = itemNew.Pieces.Add(null, null);

			DateTime pieceStart = DateTime.Now.AddHours(intIndentLevel * 2);
			pieceNew.Start = pieceStart;
			pieceNew.Finish = pieceStart.AddHours(2);

			return itemNew;
		}

		/// <summary>
		/// qACe\^\܂B
		/// </summary>
		/// <param name="intParentItemIndex">
		/// eACẽCfbNXB
		/// </param>
		/// <param name="blnHidden">
		/// \ꍇtrueA\ꍇfalsew肵܂B
		/// </param>
		private void HideChildren(int intParentItemIndex, bool blnHidden)
		{
			int intItemIndex;
			int intItemCount;
			int intParentIndentLevel;
			KnTViewLib.Item itemChild;

			intItemCount = KnTView1.Items.Count;
			intParentIndentLevel = KnTView1.Items.Item(intParentItemIndex).Cells.Item(cintTreeCellIndex).IndentLevel;

			// eACẽC[W̐ݒ
			if(blnHidden)
				SetImageToCell(cstrClose, KnTView1.Items.Item(intParentItemIndex).Cells.Item(cintTreeCellIndex));
			else
				SetImageToCell(cstrOpen, KnTView1.Items.Item(intParentItemIndex).Cells.Item(cintTreeCellIndex));

			// qACe̕\^\ݒ
			int intNextItemIndex;
			for(intItemIndex = intParentItemIndex + 1; intItemIndex <= intItemCount; intItemIndex++){
				itemChild = KnTView1.Items.Item(intItemIndex);

				// qACeȂI
				if(itemChild.Cells.Item(cintTreeCellIndex).IndentLevel <= intParentIndentLevel)
					return;

				// \^\ݒ
				itemChild.Hidden = blnHidden;

				// qACeACeĂꍇAXLbv
				if(!blnHidden && itemChild.Cells.Item(cintTreeCellIndex).Tag == cstrClose){
					for(intNextItemIndex = intItemIndex + 1; intNextItemIndex <= intItemCount; intNextItemIndex++){
						if(KnTView1.Items.Item(intNextItemIndex).Cells.Item(cintTreeCellIndex).IndentLevel <= itemChild.Cells.Item(cintTreeCellIndex).IndentLevel)
							break;
					}
					intItemIndex = intNextItemIndex - 1;
				}
			}
		}

		/// <summary>
		/// qACe܂߂Ĉړ܂B
		/// </summary>
		/// <param name="intOldItemIndex">
		/// ړÕACeCfbNXB
		/// </param>
		/// <param name="intNewItemIndex">
		/// ړ̃ACeCfbNXB
		/// </param>
		private void MoveItems(int intOldItemIndex, int intNewItemIndex)
		{
			int	intMoveItemCount;
			int	intOldParentItemIndex;
			int	intCurrentIndentLevel;

			intCurrentIndentLevel = KnTView1.Items.Item(intNewItemIndex).Cells.Item(cintTreeCellIndex).IndentLevel;

			if(HasParent(intOldItemIndex))
				intOldParentItemIndex = intOldItemIndex - 1;
			else
				intOldParentItemIndex = 0;

			intMoveItemCount = GetChildrenCount(intOldItemIndex) + 1;

			// ւ̈ړ̏ꍇ́AqACeXLbv
			if(intOldItemIndex < intNewItemIndex)
				intNewItemIndex = intNewItemIndex + GetChildrenCount(intNewItemIndex);
			
			// ACeړ
			intNewItemIndex = KnTView1.Items.Move(intOldItemIndex, intNewItemIndex, intMoveItemCount);
			
			// ړłȂꍇ͂̂܂܏I
			if(intNewItemIndex <= 0)
				return;
			
			// Cfg̐ݒ
			if(intNewItemIndex == 1)
				SetIndent(intNewItemIndex, 1, intMoveItemCount - 1);
			else if(KnTView1.Items.Item(intNewItemIndex).Cells.Item(cintTreeCellIndex).IndentLevel > intCurrentIndentLevel) 
				SetIndent(intNewItemIndex, intCurrentIndentLevel + 1, intMoveItemCount - 1);
			else
				SetIndent(intNewItemIndex, intCurrentIndentLevel, intMoveItemCount - 1);
			
			// ZC[W̒
			AdjustCellImage(intNewItemIndex);
			
			// ̃ACe̐eACẽZC[W
			if(intOldParentItemIndex != 0)
				AdjustCellImage(intOldParentItemIndex + intMoveItemCount);
		}

		/// <summary>
		/// qACe܂߂ăCfgύX܂B
		/// </summary>
		/// <param name="intParentItemIndex">
		/// eACẽCfbNXB
		/// </param>
		/// <param name="intNewIndentLevel">
		/// ݒ肷CfgxB
		/// </param>
		private void SetIndent(int intParentItemIndex, int intNewIndentLevel, int intChildItemCount)
		{
			int	intChildItemIndex;
			int	intOldChildIndentLevel;
			int	intChildIndentLevel;
			int	intEndIndentLevel;
			
			if(KnTView1.Items.Item(intParentItemIndex).Cells.Item(cintTreeCellIndex).IndentLevel > intNewIndentLevel)
				intEndIndentLevel = intNewIndentLevel;
			else
				intEndIndentLevel = KnTView1.Items.Item(intParentItemIndex).Cells.Item(cintTreeCellIndex).IndentLevel;
			
			// Ώۂ̃ACe
			KnTView1.Items.Item(intParentItemIndex).Cells.Item(cintTreeCellIndex).IndentLevel = intNewIndentLevel;
			
			// qACe
			intOldChildIndentLevel = 1;
			intChildIndentLevel = intNewIndentLevel;
			for(intChildItemIndex = intParentItemIndex + 1; intChildItemIndex <= KnTView1.Items.Count; intChildItemIndex++){
				if(intChildItemCount <= 0)
					return;

				intChildItemCount = intChildItemCount - 1;
				if(KnTView1.Items.Item(intChildItemIndex).Cells.Item(cintTreeCellIndex).IndentLevel <= intEndIndentLevel)
					return;
				
				if(intOldChildIndentLevel < KnTView1.Items.Item(intChildItemIndex).Cells.Item(cintTreeCellIndex).IndentLevel){
					intChildIndentLevel = intChildIndentLevel + 1;
					intOldChildIndentLevel = KnTView1.Items.Item(intChildItemIndex).Cells.Item(cintTreeCellIndex).IndentLevel;
				}
				KnTView1.Items.Item(intChildItemIndex).Cells.Item(cintTreeCellIndex).IndentLevel = intChildIndentLevel;
			}
		}

		/// <summary>
		/// eACeĂ邩`FbN܂B
		/// </summary>
		/// <param name="intItemIndex">
		/// ΏۃACẽCfbNXB
		/// </param>
		/// <returns>
		/// eACeĂꍇtrueԂ܂B
		/// </returns>
		private bool HasParent(int intItemIndex)
		{
			int intParentIndentLevel;
			if(intItemIndex <= 1)
				return false;
			else{
				intParentIndentLevel = KnTView1.Items.Item(intItemIndex - 1).Cells.Item(cintTreeCellIndex).IndentLevel;
				if(KnTView1.Items.Item(intItemIndex).Cells.Item(cintTreeCellIndex).IndentLevel > intParentIndentLevel)
					return true;
				else
					return false;
			}
		}

		/// <summary>
		/// qACe̐擾܂B
		/// </summary>
		/// <param name="intItemIndex">
		/// ΏۃACẽCfbNXB
		/// </param>
		/// <returns>
		/// qACe̐B
		/// </returns>
		private int GetChildrenCount(int intItemIndex)
		{
			int	intChildrenCount	= 0;
			int	intChildItemIndex;

			if(intItemIndex < KnTView1.Items.Count){
				
				for(intChildItemIndex = intItemIndex + 1; intChildItemIndex <= KnTView1.Items.Count; intChildItemIndex++){
					if(KnTView1.Items.Item(intItemIndex).Cells.Item(cintTreeCellIndex).IndentLevel < KnTView1.Items.Item(intChildItemIndex).Cells.Item(cintTreeCellIndex).IndentLevel)
						intChildrenCount++;
					else
						return intChildrenCount;
				}
			}

			return intChildrenCount;
		}

		/// <summary>
		/// qACe\Ă邩`FbN܂B
		/// </summary>
		/// <param name="intItemIndex">
		/// ΏۃACẽCfbNXB
		/// </param>
		/// <returns>
		/// qACe\ĂꍇtrueԂ܂B
		/// </returns>
		private bool IsOpen(int intItemIndex)
		{
			if(GetChildrenCount(intItemIndex) > 0){
				if(KnTView1.Items.Item(intItemIndex).Cells.Item(cintTreeCellIndex).Tag == cstrOpen)
					return true;
				else
					return false;
			}

			return false;
		}

		/// <summary>
		/// RGBJ[l𐶐܂B
		/// </summary>
		/// <param name="red">
		/// Ԃ̒lB
		/// </param>
		/// <param name="green">
		/// ΂̒lB
		/// </param>
		/// <param name="blue">
		/// ̒lB
		/// </param>
		/// <returns>
		/// RGBJ[lB
		/// </returns>
		private uint RGB(int red, int green, int blue) 
		{
			return (uint)(blue << 16 | green << 8 | red);
		}
	}
}
